USE [RetailPOS_DB]
GO

/****** Object:  Table [dbo].[Quotation]    Script Date: 08-12-2021 18:54:11 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Quotation](
	[Inv_ID] [int] NOT NULL,
	[InvoiceNo] [nchar](30) NOT NULL,
	[InvoiceDate] [datetime] NOT NULL,
	[CurrencyCode] [nchar](50) NULL,
	[ExchangeRate] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_ExchangeRate]  DEFAULT ((1.00)),
	[DiscPer] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_DiscPer]  DEFAULT ((0.00)),
	[DiscAmt] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_DiscAmt]  DEFAULT ((0.00)),
	[GrandTotal] [decimal](18, 2) NULL,
	[TaxType] [nchar](20) NULL,
	[CustID] [int] NULL CONSTRAINT [DF_Quotation_CustID]  DEFAULT ((0)),
	[BillNote] [nvarchar](max) NULL,
	[CName] [nchar](150) NULL,
	[CCN] [nchar](50) NULL,
	[RoundOff] [decimal](18, 2) NULL CONSTRAINT [Quotation_RoundOff]  DEFAULT ((0.00)),
	[UserID] [nchar](100) NULL,
	[Status] [nchar](20) NULL,
 CONSTRAINT [PK_Quotation] PRIMARY KEY CLUSTERED 
(
	[Inv_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[Quotation]  WITH CHECK ADD  CONSTRAINT [FK_Quotation_Customer] FOREIGN KEY([CustID])
REFERENCES [dbo].[Customer] ([CC_ID])
ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[Quotation] CHECK CONSTRAINT [FK_Quotation_Customer]
GO

ALTER TABLE [dbo].[Quotation]  WITH CHECK ADD  CONSTRAINT [FK_Quotation_Registration] FOREIGN KEY([UserID])
REFERENCES [dbo].[Registration] ([UserID])
ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[Quotation] CHECK CONSTRAINT [FK_Quotation_Registration]
GO

